/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32.components;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import walnoot.ld32.Assets;
import walnoot.ld32.Component;
import walnoot.ld32.Entity;
import walnoot.ld32.OffsetSprite;
import walnoot.ld32.components.ArrowPickupComponent;
import walnoot.ld32.components.BodyInfoComponent;
import walnoot.ld32.components.BulletComponent;
import walnoot.ld32.components.PlayerComponent;
import walnoot.ld32.components.SpriteComponent;

public class EnemyComponent
extends Component {
    private static final float TURN_SPEED = 200.0f;
    private static final float HEAR_RANGE = 1.0f;
    private static final float SIGHT_RANGE = 7.0f;
    private static final int TURN_TIME = 240;
    private Vector2 tmp1 = new Vector2();
    private Vector2 tmp2 = new Vector2();
    private Vector2 aimDir = new Vector2(1.0f, 0.0f);
    private OffsetSprite sprite;
    private OffsetSprite coneSprite;
    private int fireTimer;
    private int seeingTimer;
    private int turnTimer = 60;
    private boolean aggro = false;
    private Array<Vector2> path = new Array();
    private int pathIndex = 0;

    public EnemyComponent(Array<Vector2> path, float rotation) {
        this.path.addAll(path);
        this.aimDir.rotate(rotation);
    }

    @Override
    public void init() {
        this.owner.addComponent(new SpriteComponent());
        this.sprite = this.owner.getComponent(SpriteComponent.class).addSprite(Assets.get("enemy"), 1.0f);
        this.coneSprite = this.owner.getComponent(SpriteComponent.class).addSprite(Assets.get("view_cone"), 7.0f, 3.5f, 3.5f, 0.0f);
        this.coneSprite.level = -2;
    }

    @Override
    public void render(Array<Sprite> sprites) {
        this.sprite.setRotation(this.aimDir.angle() - 90.0f);
        this.coneSprite.setRotation(this.aimDir.angle() - 45.0f);
    }

    @Override
    public void update() {
        Entity player = null;
        for (Entity e : this.owner.world.queryRadius(this.owner, this.aggro ? 14.0f : 7.0f)) {
            if (e.getComponent(PlayerComponent.class) == null) continue;
            player = e;
        }
        boolean firing = false;
        Vector2 goal = null;
        if (this.seeingTimer-- > 0 && player != null) {
            goal = player.body.getPosition();
        }
        if (player != null) {
            Vector2 sub = this.tmp1.set(player.body.getPosition()).sub(this.owner.body.getPosition());
            float len2 = sub.len2();
            Vector2 dir = sub.nor();
            if (len2 < 1.0f || dir.dot(this.aimDir) > MathUtils.cosDeg(50.0f)) {
                firing = true;
                this.aggro = true;
                this.seeingTimer = 60;
                if (this.fireTimer++ == 30) {
                    this.fireTimer = 0;
                    SpriteComponent spriteComponent = new SpriteComponent();
                    OffsetSprite bulletSprite = spriteComponent.addSprite(Assets.get("dot"), 0.25f);
                    bulletSprite.setScale(0.5f, 2.0f);
                    bulletSprite.setRotation(this.aimDir.angle() - 90.0f);
                    spriteComponent.setLevel(-1);
                    this.owner.world.addEntity(this.owner.getX(), this.owner.getY(), spriteComponent, new BulletComponent(EnemyComponent.class, this.aimDir, 20.0f), new BodyInfoComponent(false));
                    this.aimDir.set(this.aimDir);
                }
            }
        }
        if (goal == null && !firing && this.path.size > 0) {
            goal = this.path.get(this.pathIndex);
            if (this.owner.body.getPosition().dst2(goal) < 1.0f) {
                ++this.pathIndex;
                if (this.pathIndex == this.path.size) {
                    this.pathIndex = 0;
                }
            }
        }
        if (goal != null) {
            this.tmp1.set(this.owner.body.getPosition()).sub(goal).nor();
            if (-this.aimDir.dot(this.tmp1) > MathUtils.cosDeg(5.0f)) {
                this.owner.body.setLinearVelocity(this.tmp1.set(this.aimDir).scl(2.0f));
            } else {
                this.tmp2.set(this.aimDir).rotate90(1);
                if (this.tmp2.dot(this.tmp1.set(goal).sub(this.owner.body.getPosition())) > 0.0f) {
                    this.aimDir.rotate(3.3333333f);
                } else {
                    this.aimDir.rotate(-3.3333333f);
                }
            }
        } else {
            this.turnTimer = (this.turnTimer + 1) % 240;
            if (this.turnTimer > 120) {
                this.aimDir.rotate(0.8333333f);
            } else {
                this.aimDir.rotate(-0.8333333f);
            }
        }
    }

    @Override
    public void onRemove() {
        int amount = MathUtils.random(1, 3);
        int i = 0;
        while (i < amount) {
            Entity e = new Entity();
            e.addComponent(new SpriteComponent(Assets.get("arrow"), 1.0f));
            e.addComponent(new ArrowPickupComponent());
            e.addComponent(new BodyInfoComponent(false));
            this.owner.world.addEntity(e, this.owner.getX() + (float)i / 5.0f, this.owner.getY());
            ++i;
        }
    }
}

