/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32.components;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import walnoot.ld32.Component;
import walnoot.ld32.Entity;
import walnoot.ld32.components.HealthComponent;
import walnoot.ld32.components.LowComponent;

public class BulletComponent
extends Component
implements RayCastCallback {
    private Vector2 dir = new Vector2();
    private Class<? extends Component> sender;
    private Entity nearestEntity;
    private Vector2 tmp = new Vector2();
    private float length;
    private float speed;
    private int timeAlive;

    public BulletComponent(Class<? extends Component> sender, Vector2 dir, float speed) {
        this(sender, dir, speed, 0.0f);
    }

    public BulletComponent(Class<? extends Component> sender, Vector2 dir, float speed, float length) {
        this.sender = sender;
        this.speed = speed;
        this.dir.set(dir).scl(speed);
        this.length = length;
    }

    @Override
    public void update() {
        this.owner.body.setLinearVelocity(this.dir);
        this.nearestEntity = null;
        Vector2 pos = this.owner.body.getPosition();
        this.owner.body.getWorld().rayCast(this, pos, this.tmp.set(this.dir).scl(0.016666668f + this.length / this.speed).add(pos));
        if (this.nearestEntity != null) {
            HealthComponent healthComponent = this.nearestEntity.getComponent(HealthComponent.class);
            if (!this.nearestEntity.hasComponent(this.sender)) {
                if (healthComponent != null) {
                    healthComponent.hit(1);
                }
                this.owner.remove();
            }
        }
        int n = this.timeAlive++;
        if ((float)n > 300.0f) {
            this.owner.remove();
        }
    }

    @Override
    public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
        Entity entity = (Entity)fixture.getBody().getUserData();
        if (entity.hasComponent(LowComponent.class)) {
            return 1.0f;
        }
        this.nearestEntity = entity;
        return fraction;
    }
}

