/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.utils.ScreenUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;

public class Timelapse {
    private static final long TIME_BETWEEN_CAPTURES = 1000L;
    private static final String PATH = "C:\\Users\\Michiel\\Desktop\\capture\\";
    private static long lastCaptureTime = 0L;
    private static final ArrayBlockingQueue<Pixmap> captureQueue = new ArrayBlockingQueue(5);
    private static CaptureIOThread thread = new CaptureIOThread();

    public static void update() {
        long now;
        if (!thread.isAlive()) {
            thread.start();
        }
        if ((now = System.currentTimeMillis()) - lastCaptureTime > 1000L) {
            lastCaptureTime = now;
            Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            try {
                captureQueue.put(pixmap);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class CaptureIOThread
    extends Thread {
        private int index = -1;

        public CaptureIOThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Pixmap pixmap = (Pixmap)captureQueue.take();
                        int w = pixmap.getWidth();
                        int h = pixmap.getHeight();
                        ByteBuffer pixels = pixmap.getPixels();
                        int numBytes = w * h * 4;
                        byte[] lines = new byte[numBytes];
                        int numBytesPerLine = w * 4;
                        int i = 0;
                        while (i < h) {
                            pixels.position((h - i - 1) * numBytesPerLine);
                            pixels.get(lines, i * numBytesPerLine, numBytesPerLine);
                            ++i;
                        }
                        pixels.clear();
                        pixels.put(lines);
                        this.index = this.getIndex();
                        String p = String.format("C:\\Users\\Michiel\\Desktop\\capture\\test_%d.png", this.index);
                        PixmapIO.writePNG(Gdx.files.absolute(p), pixmap);
                        pixmap.dispose();
                        ++this.index;
                        this.writeIndex();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private int getIndex() {
            if (this.index == -1) {
                try {
                    FileInputStream stream = new FileInputStream("C:\\Users\\Michiel\\Desktop\\capture\\index.txt");
                    int i = new DataInputStream(stream).readInt();
                    System.out.println("read " + i);
                    stream.close();
                    return i;
                }
                catch (FileNotFoundException e) {
                    return 0;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
            return this.index;
        }

        private void writeIndex() {
            try {
                FileOutputStream stream = new FileOutputStream("C:\\Users\\Michiel\\Desktop\\capture\\index.txt");
                new DataOutputStream(stream).writeInt(this.index);
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

