/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import walnoot.ld32.Assets;
import walnoot.ld32.Input;
import walnoot.ld32.IntroState;
import walnoot.libgdxutils.State;
import walnoot.libgdxutils.StateApplication;
import walnoot.libgdxutils.input.InputHandler;

public class LD32Game
extends StateApplication {
    public static final float FPS = 60.0f;
    private static final boolean DEBUG = false;

    public LD32Game() {
        super(60.0f, false);
    }

    @Override
    protected void init() {
        Input.i = InputHandler.read(Gdx.files.internal("input.json"));
        Gdx.input.setInputProcessor(Input.i);
        PixmapPacker packer = new PixmapPacker(1024, 1024, Pixmap.Format.RGBA8888, 2, true);
        this.pack(packer, "arrow");
        this.pack(packer, "bow");
        this.pack(packer, "box");
        this.pack(packer, "crate");
        this.pack(packer, "dot");
        this.pack(packer, "enemy");
        this.pack(packer, "exit");
        this.pack(packer, "fence_straight");
        this.pack(packer, "fence_corner");
        this.pack(packer, "player");
        this.pack(packer, "view_cone");
        Assets.ATLAS = packer.generateTextureAtlas(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear, false);
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = 32;
        Assets.FONT = new FreeTypeFontGenerator(Gdx.files.internal("OpenSans-Regular.ttf")).generateFont(parameter);
    }

    private void pack(PixmapPacker packer, String name) {
        packer.pack(name, new Pixmap(Gdx.files.internal(String.valueOf(name) + ".png")));
    }

    @Override
    protected void update() {
        super.update();
        Input.i.update();
    }

    @Override
    protected State getFirstState() {
        return new IntroState(Controllers.getControllers().size > 0);
    }
}

