/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import walnoot.ld32.GameState;
import walnoot.libgdxutils.State;

public class IntroState
extends State {
    private Texture texture;
    private SpriteBatch batch = new SpriteBatch();
    private boolean controller;

    public IntroState(boolean controller) {
        this.controller = controller;
        this.texture = new Texture(Gdx.files.internal(controller ? "intro_controller.png" : "intro_keyboard.png"), true);
        this.texture.setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
    }

    @Override
    public void render() {
        Gdx.gl20.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl20.glClear(16384);
        float x = (float)(Gdx.graphics.getWidth() - Gdx.graphics.getHeight()) / 2.0f;
        this.batch.begin();
        this.batch.draw(this.texture, x, 0.0f, (float)Gdx.graphics.getHeight(), (float)Gdx.graphics.getHeight());
        this.batch.end();
        if (Gdx.input.isKeyJustPressed(66)) {
            this.manager.setState(new IntroState(false));
        }
        if (Gdx.input.isKeyJustPressed(62)) {
            this.manager.setState(new GameState(this.controller));
        }
        if (this.controller && Controllers.getControllers().get(0).getButton(0)) {
            this.manager.setState(new GameState(this.controller));
        }
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, width, height);
    }
}

