/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.QueryCallback;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import walnoot.ld32.Component;
import walnoot.ld32.Entity;
import walnoot.ld32.PlayerData;
import walnoot.ld32.components.BodyInfoComponent;
import walnoot.ld32.components.HealthComponent;
import walnoot.ld32.components.PlayerComponent;
import walnoot.ld32.components.SpriteComponent;

public class GameWorld
implements QueryCallback {
    private World world = new World(Vector2.Zero, true);
    private Array<Body> bodies = new Array();
    private Array<Body> removedBodies = new Array();
    private OrthographicCamera camera;
    private Array<Sprite> sprites = new Array();
    private final boolean useController;
    private Array<Entity> tempEntities = new Array();
    private float queryX;
    private float queryY;
    private float queryRadius;
    private String nextLevel;

    public GameWorld(OrthographicCamera camera, boolean useController, float x, float y, PlayerData data) {
        this.camera = camera;
        this.useController = useController;
        camera.position.set(x, y, 0.0f);
        this.addEntity(x, y, new SpriteComponent(), new PlayerComponent(camera, data), new HealthComponent(3));
    }

    public void update() {
        this.world.getBodies(this.bodies);
        for (Body body : this.bodies) {
            ((Entity)body.getUserData()).update();
        }
        for (Body body : this.removedBodies) {
            this.world.destroyBody(body);
        }
        this.removedBodies.clear();
        this.world.step(0.016666668f, 8, 3);
    }

    public void render(SpriteBatch batch) {
        this.world.getBodies(this.bodies);
        this.sprites.clear();
        for (Body body : this.bodies) {
            ((Entity)body.getUserData()).render(this.sprites);
        }
        this.sprites.sort();
        for (Sprite s : this.sprites) {
            s.draw(batch);
        }
    }

    public void addEntity(float x, float y, Component ... components) {
        Entity entity = new Entity();
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            entity.addComponent(c);
            ++n2;
        }
        this.addEntity(entity, x, y);
    }

    public void addEntity(Entity entity, float x, float y) {
        BodyDef def = new BodyDef();
        def.type = entity.isStatic() ? BodyDef.BodyType.StaticBody : BodyDef.BodyType.DynamicBody;
        def.fixedRotation = true;
        def.position.set(x, y);
        def.linearDamping = 4.0f;
        BodyInfoComponent bodyInfo = entity.getComponent(BodyInfoComponent.class);
        Body body = this.world.createBody(def);
        body.setUserData(entity);
        entity.body = body;
        entity.world = this;
        if (bodyInfo != null && bodyInfo.fixtureDef != null) {
            body.createFixture(bodyInfo.fixtureDef);
        } else if (bodyInfo == null || bodyInfo.solid) {
            CircleShape shape = new CircleShape();
            shape.setRadius(entity.getRadius());
            FixtureDef fDef = new FixtureDef();
            fDef.shape = shape;
            fDef.density = 1.0f;
            fDef.friction = 0.0f;
            body.createFixture(fDef);
            shape.dispose();
        }
        entity.init();
    }

    public void removeEntity(Entity e) {
        this.removedBodies.add(e.body);
    }

    public Array<Entity> queryRadius(Entity e, float radius) {
        return this.queryRadius(e.getX(), e.getY(), radius);
    }

    public Array<Entity> queryRadius(float x, float y, float radius) {
        this.tempEntities.clear();
        this.queryX = x;
        this.queryY = y;
        this.queryRadius = radius;
        this.world.QueryAABB(this, x - radius, y - radius, x + radius, y + radius);
        return this.tempEntities;
    }

    public <T extends Component> Entity findEntityWith(Class<T> c) {
        this.world.getBodies(this.bodies);
        int i = 0;
        while (i < this.bodies.size) {
            Entity e = (Entity)this.bodies.get(i).getUserData();
            if (e.hasComponent(c)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean reportFixture(Fixture fixture) {
        Body b = fixture.getBody();
        if (b.getPosition().dst2(this.queryX, this.queryY) < this.queryRadius * this.queryRadius) {
            this.tempEntities.add((Entity)b.getUserData());
        }
        return true;
    }

    public void markFinished(String level) {
        this.nextLevel = level;
    }

    public String getNextLevel() {
        return this.nextLevel;
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public World getWorld() {
        return this.world;
    }

    public boolean useController() {
        return this.useController;
    }
}

