/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import walnoot.ld32.Assets;
import walnoot.ld32.EndState;
import walnoot.ld32.Entity;
import walnoot.ld32.GameWorld;
import walnoot.ld32.LevelLoader;
import walnoot.ld32.PlayerData;
import walnoot.ld32.components.HealthComponent;
import walnoot.ld32.components.PlayerComponent;
import walnoot.libgdxutils.State;
import walnoot.libgdxutils.Transition;

public class GameState
extends State {
    private static final Color BG_COLOR = new Color(-557938689);
    private SpriteBatch batch = new SpriteBatch();
    private OrthographicCamera gameCamera = new OrthographicCamera();
    private OrthographicCamera uiCamera = new OrthographicCamera();
    private GameWorld world;
    private boolean useController;
    private boolean gameOver;
    private String level;
    private PlayerData startData;

    public GameState(boolean useController) {
        this(useController, "level1.json", new PlayerData());
    }

    public GameState(boolean useController, String level, PlayerData data) {
        this.useController = useController;
        this.level = level;
        this.startData = new PlayerData(data);
        this.world = LevelLoader.loadLevel(level, this.gameCamera, useController, data);
    }

    @Override
    public void update() {
        this.world.update();
        Entity player = this.world.findEntityWith(PlayerComponent.class);
        if (this.world.getNextLevel() != null) {
            PlayerData data = player.getComponent(PlayerComponent.class).getData();
            String nextLevel = this.world.getNextLevel();
            if (nextLevel.equals("end")) {
                this.manager.transitionTo(new EndState(), new Transition.FadeTransition(1.0f));
            } else {
                this.manager.transitionTo(new GameState(this.useController, nextLevel, data), new Transition.FadeTransition(1.0f));
            }
        }
        boolean bl = this.gameOver = player == null;
        if (this.gameOver && Gdx.input.isKeyJustPressed(62)) {
            this.manager.transitionTo(new GameState(this.useController, this.level, this.startData), new Transition.FadeTransition(1.0f));
        }
    }

    @Override
    public void render() {
        Color c = BG_COLOR;
        Gdx.gl20.glClearColor(c.r, c.g, c.b, 1.0f);
        Gdx.gl20.glClear(16384);
        this.gameCamera.update();
        this.batch.setProjectionMatrix(this.gameCamera.combined);
        this.batch.begin();
        this.world.render(this.batch);
        this.batch.setProjectionMatrix(this.uiCamera.combined);
        Entity player = this.world.findEntityWith(PlayerComponent.class);
        if (player != null) {
            String s = "Arrows: " + player.getComponent(PlayerComponent.class).getData().getArrows();
            HealthComponent health = player.getComponent(HealthComponent.class);
            if (health != null) {
                s = String.valueOf(s) + "   Health: " + player.getComponent(HealthComponent.class).getHealth() + "/" + health.getMaxHealth();
            }
            Assets.FONT.draw(this.batch, s, 10.0f, Assets.FONT.getCapHeight() + 10.0f);
        }
        if (this.gameOver) {
            Assets.FONT.draw(this.batch, "Game over. Press Space to Continue.", 10.0f, (float)Gdx.graphics.getHeight() - 10.0f);
        }
        this.batch.end();
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        this.gameCamera.viewportWidth = 2.0f * (float)width / (float)height;
        this.gameCamera.viewportHeight = 2.0f;
        this.gameCamera.zoom = 8.0f;
        this.uiCamera.setToOrtho(false);
    }

    public boolean useController() {
        return this.useController;
    }
}

