/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld32;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import walnoot.ld32.Component;
import walnoot.ld32.GameWorld;
import walnoot.ld32.components.BodyInfoComponent;

public class Entity {
    public Body body;
    public GameWorld world;
    private static Array<Component> removedComponents = new Array();
    private Array<Component> components = new Array();
    private IntMap<Component> componentMap = new IntMap();

    public void init() {
        for (Component c : this.components) {
            c.init();
        }
    }

    public void update() {
        removedComponents.clear();
        for (Component c : this.components) {
            if (!c.removed) {
                c.update();
                continue;
            }
            removedComponents.add(c);
        }
        this.components.removeAll(removedComponents, true);
    }

    public void render(Array<Sprite> sprites) {
        for (Component c : this.components) {
            c.render(sprites);
        }
    }

    public boolean isStatic() {
        BodyInfoComponent bodyInfoComponent = this.getComponent(BodyInfoComponent.class);
        if (bodyInfoComponent != null) {
            return bodyInfoComponent.isStatic;
        }
        return false;
    }

    public float getRadius() {
        for (Component c : this.components) {
            if (c.getRadius() == 0.0f) continue;
            return c.getRadius();
        }
        return 0.5f;
    }

    public float getX() {
        return this.body.getPosition().x;
    }

    public float getY() {
        return this.body.getPosition().y;
    }

    public void addComponent(Component component) {
        component.owner = this;
        this.components.add(component);
        this.componentMap.put(component.getClass().hashCode(), component);
    }

    public <T extends Component> boolean hasComponent(Class<T> c) {
        return this.getComponent(c) != null;
    }

    public <T extends Component> T getComponent(Class<T> c) {
        return (T)((Component)this.componentMap.get(c.hashCode(), null));
    }

    public void remove() {
        int i = 0;
        while (i < this.components.size) {
            this.components.get(i).onRemove();
            ++i;
        }
        this.world.removeEntity(this);
    }
}

