/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26.particles;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import walnoot.ld26.particles.Particle;

public class ParticleHandler {
    public static ParticleHandler instance = new ParticleHandler();
    private static final Color TEMP_COLOR = new Color();
    private Array<Particle> particles = new Array(false, 128);
    private final Mesh[] meshes = new Mesh[8];

    private ParticleHandler() {
        int i = 0;
        while (i < this.meshes.length) {
            this.meshes[i] = this.getRandomMesh();
            ++i;
        }
    }

    private Mesh getRandomMesh() {
        int numVertices = MathUtils.random(3, 7);
        Mesh mesh = new Mesh(true, numVertices, 0, new VertexAttribute(0, 2, "a_position"));
        float[] vertices = new float[numVertices * 2];
        int i = 0;
        while (i < numVertices) {
            float rad = (float)Math.PI * 2 * (float)i / (float)numVertices;
            float dist = MathUtils.random(0.1f, 0.4f);
            vertices[i * 2] = MathUtils.cos(rad) * dist;
            vertices[i * 2 + 1] = MathUtils.sin(rad) * dist;
            ++i;
        }
        mesh.setVertices(vertices);
        return mesh;
    }

    public void createEffect(Vector2 pos) {
        int i = 0;
        while (i < 16) {
            float rad = MathUtils.random(0.0f, (float)Math.PI * 2);
            float xVel = MathUtils.cos(rad);
            float yVel = MathUtils.sin(rad);
            int life = (int)(MathUtils.random(1.0f, 1.5f) * 60.0f);
            float spinSpeed = MathUtils.random(0.0f, 180.0f);
            if (MathUtils.randomBoolean()) {
                spinSpeed = -spinSpeed;
            }
            TEMP_COLOR.set(MathUtils.random(), MathUtils.random(), MathUtils.random(), 1.0f);
            this.particles.add(new Particle(pos.x, pos.y, xVel, yVel, this.meshes[MathUtils.random(0, this.meshes.length - 1)], TEMP_COLOR, life, spinSpeed));
            ++i;
        }
    }

    public void render() {
        for (Particle p : this.particles) {
            p.render();
        }
    }

    public void update() {
        int i = 0;
        while (i < this.particles.size) {
            Particle particle = this.particles.get(i);
            if (!particle.removed) {
                particle.update();
            } else {
                this.particles.removeIndex(i);
                --i;
            }
            ++i;
        }
    }
}

