/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26.particles;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.math.Vector2;

public class Particle {
    private int lifeTime;
    public boolean removed = false;
    private final float spinSpeed;
    private Vector2 position;
    private Vector2 velocity;
    private final Mesh mesh;
    private final Color color = new Color();
    private float angle;

    public Particle(float x, float y, float xVel, float yVel, Mesh mesh, Color color, int lifeTime, float spinSpeed) {
        this.position = new Vector2(x, y);
        this.velocity = new Vector2(xVel * 0.016666668f, yVel * 0.016666668f);
        this.mesh = mesh;
        this.color.set(color);
        this.lifeTime = lifeTime;
        this.spinSpeed = spinSpeed * 0.016666668f;
    }

    public void update() {
        --this.lifeTime;
        if (this.lifeTime == 0) {
            this.removed = true;
        }
        this.angle += this.spinSpeed;
        this.position.add(this.velocity);
    }

    public void render() {
        Gdx.gl10.glPushMatrix();
        Gdx.gl10.glTranslatef(this.position.x, this.position.y, 0.0f);
        Gdx.gl10.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        Gdx.gl10.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
        this.mesh.render(6);
        Gdx.gl10.glPopMatrix();
    }
}

