/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26.entities.enemies;

import com.badlogic.gdx.math.Vector2;
import walnoot.ld26.GameWorld;
import walnoot.ld26.Util;
import walnoot.ld26.WaveManager;
import walnoot.ld26.entities.PlayerEntity;
import walnoot.ld26.entities.enemies.EnemyEntity;

public class SplitEnemy
extends EnemyEntity {
    private static final float START_RADIUS = 2.0f;
    private static final float SPEED = 5.0f;
    private final int splitTimes;
    private final float size;

    public SplitEnemy(float x, float y, PlayerEntity player) {
        this(x, y, player, 2, 2.0f, 60.0f);
    }

    public SplitEnemy(float x, float y, PlayerEntity player, int splitTimes, float size, float maxHealth) {
        super(Util.getCircleBody(Vector2.tmp.set(x, y), Util.getCircleShape(size)), player, 0.3f, 0.6f, maxHealth);
        this.splitTimes = splitTimes;
        this.size = size;
        this.setRadius(size);
    }

    @Override
    public void update() {
        super.update();
        Vector2 translation = Vector2.tmp.set(this.player.getBody().getPosition()).sub(this.body.getPosition()).nor().mul(5.0f / this.size);
        this.body.setLinearVelocity(translation);
    }

    @Override
    public void onRemove() {
        super.onRemove();
        if (this.splitTimes > 0) {
            GameWorld.instance.addEntity(new SplitEnemy(this.pos.x - 1.0f, this.pos.y, this.player, this.splitTimes - 1, this.size * 0.5f, this.getMaxHealth() * 0.25f));
            GameWorld.instance.addEntity(new SplitEnemy(this.pos.x + 1.0f, this.pos.y, this.player, this.splitTimes - 1, this.size * 0.5f, this.getMaxHealth() * 0.25f));
            WaveManager.instance.enemiesRemaining += 2;
        }
    }
}

