/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26.entities.enemies;

import com.badlogic.gdx.math.Vector2;
import walnoot.ld26.entities.PlayerEntity;
import walnoot.ld26.entities.enemies.EnemyEntity;

public class ChargeEnemy
extends EnemyEntity {
    private static final int CHARGE_TIME = 30;
    private static final float CHARGE_FORCE = 60.0f;
    private static final float SPEED_THRESHOLD_SQUARED = 1.0f;
    private int chargeTimer = 0;
    private Vector2 force = new Vector2();

    public ChargeEnemy(float x, float y, PlayerEntity player) {
        super(x, y, player, 0.5f, 0.4f, 20.0f);
        this.body.setLinearDamping(1.0f);
    }

    @Override
    public void update() {
        super.update();
        if (this.body.getLinearVelocity().len2() < 1.0f) {
            this.chargeTimer = 30;
            this.force.set(this.player.pos).sub(this.pos).nor().mul(60.0f);
        }
        if (this.chargeTimer > 0) {
            --this.chargeTimer;
            this.body.applyForceToCenter(this.force);
        }
    }
}

