/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26.entities;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.Vector2;
import walnoot.ld26.Util;
import walnoot.ld26.entities.LivingEntity;
import walnoot.ld26.entities.WreckBallEntity;

public class PlayerEntity
extends LivingEntity
implements InputProcessor {
    public static final float SPEED = 8.0f;
    public static final float TURN_SPEED = 4.0f;
    public int murderCount;
    private final WreckBallEntity ball;

    public PlayerEntity(float x, float y, WreckBallEntity ball) {
        super(Util.getCircleBody(Vector2.tmp.set(0.0f, 0.0f)), 1.0f, 0.9f, 200.0f);
        this.ball = ball;
    }

    @Override
    public void update() {
        super.update();
        Vector2 translation = Vector2.tmp.set(0.0f, 0.0f);
        if (Util.keyDown(19, 51)) {
            translation.add(0.0f, 1.0f);
        }
        if (Util.keyDown(20, 47)) {
            translation.add(0.0f, -1.0f);
        }
        if (Util.keyDown(21, 29)) {
            translation.add(-1.0f, 0.0f);
        }
        if (Util.keyDown(22, 32)) {
            translation.add(1.0f, 0.0f);
        }
        translation.nor().mul(8.0f);
        this.body.setLinearVelocity(translation);
        if (Util.keyDown(129, 130, 62)) {
            Vector2 offset = Vector2.tmp.set(this.ball.pos).sub(this.pos);
            float len = offset.len();
            if (len < 0.1f) {
                return;
            }
            offset.nor().mul(-200.0f / len);
            this.ball.body.applyForceToCenter(offset);
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 67) {
            this.ball.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        return false;
    }

    @Override
    public boolean touchMoved(int x, int y) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }
}

