/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26.entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.MathUtils;
import walnoot.ld26.Util;
import walnoot.ld26.entities.Entity;

public abstract class MeshEntity
extends Entity {
    protected Mesh mesh;
    private float radius = 1.0f;

    public MeshEntity(float x, float y, float saturation, float value) {
        super(x, y);
        int numPoints = 100;
        this.mesh = new Mesh(true, numPoints + 2, 0, new VertexAttribute(0, 2, "a_position"), new VertexAttribute(5, 4, "a_color"));
        float[] vertices = new float[(numPoints + 2) * 3];
        Color temp = new Color(0.5f, 0.5f, 0.5f, 1.0f);
        vertices[0] = 0.0f;
        vertices[1] = 0.0f;
        vertices[2] = temp.toFloatBits();
        int i = 0;
        while (i < numPoints) {
            float completeness = (float)i / (float)numPoints;
            this.setVertice((i + 1) * 3, vertices, temp, completeness, saturation, value);
            ++i;
        }
        this.setVertice((numPoints + 1) * 3, vertices, temp, 0.0f, saturation, value);
        this.mesh.setVertices(vertices);
    }

    private void setVertice(int index, float[] vertices, Color temp, float completeness, float saturation, float value) {
        vertices[index] = MathUtils.cos((float)Math.PI * 2 * completeness);
        vertices[index + 1] = MathUtils.sin((float)Math.PI * 2 * completeness);
        Util.hsvToRgb(completeness, saturation, value, temp);
        vertices[index + 2] = temp.toFloatBits();
    }

    @Override
    public void render() {
        Gdx.gl10.glPushMatrix();
        Gdx.gl10.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl10.glTranslatef(this.pos.x, this.pos.y, -0.5f);
        Gdx.gl10.glScalef(this.radius, this.radius, 1.0f);
        this.mesh.render(6);
        Gdx.gl10.glPopMatrix();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }
}

