/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26.entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.physics.box2d.Body;
import walnoot.ld26.SoundManager;
import walnoot.ld26.Util;
import walnoot.ld26.entities.PhysicsEntity;
import walnoot.ld26.particles.ParticleHandler;

public class LivingEntity
extends PhysicsEntity {
    public static final float HEALTH_BAR_WIDTH = 1.5f;
    public static final float HEALTH_BAR_HEIGHT = 0.1f;
    public static final float HEALTH_BAR_BORDER = 0.05f;
    private static final float DAMAGE_THRESHOLD = 1.0f;
    private float health;
    private float displayHealth;
    private final float maxHealth;

    public LivingEntity(Body body, float saturation, float value, float maxHealth) {
        super(body, saturation, value);
        this.maxHealth = maxHealth;
        this.health = maxHealth;
    }

    public void onCollision(float strength) {
        this.health -= strength;
    }

    public void damage(float damage) {
        if (damage > 1.0f) {
            this.health -= damage;
            SoundManager.instance.hit.play(1.0f - 1.0f / (0.1f * damage + 1.0f));
            if (this.health < 0.0f) {
                this.remove();
            }
        }
    }

    public void heal(float amount) {
        this.health = Math.min(this.maxHealth, this.health + amount);
    }

    @Override
    public void update() {
        super.update();
        this.displayHealth += Math.min(1.6666667f, this.health - this.displayHealth);
    }

    @Override
    public void render() {
        super.render();
        Gdx.gl10.glPushMatrix();
        Gdx.gl10.glTranslatef(this.pos.x, this.pos.y + this.getRadius() + 0.5f, 0.0f);
        Gdx.gl10.glColor4f(0.8f, 0.8f, 0.8f, 1.0f);
        Gdx.gl10.glScalef(1.5f * (Math.max(this.displayHealth, 0.0f) / this.maxHealth), 0.1f, 1.0f);
        Util.SQUARE_MESH.render(6);
        Gdx.gl10.glPopMatrix();
        Gdx.gl10.glPushMatrix();
        Gdx.gl10.glTranslatef(this.pos.x, this.pos.y + this.getRadius() + 0.5f, -0.1f);
        Gdx.gl10.glColor4f(0.5f, 0.5f, 0.5f, 1.0f);
        Gdx.gl10.glScalef(1.55f, 0.15f, 1.0f);
        Util.SQUARE_MESH.render(6);
        Gdx.gl10.glPopMatrix();
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public void onRemove() {
        super.onRemove();
        ParticleHandler.instance.createEffect(this.pos);
    }
}

