/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import walnoot.ld26.GameWorld;
import walnoot.ld26.SoundManager;
import walnoot.ld26.entities.enemies.BasicEnemy;
import walnoot.ld26.entities.enemies.ChargeEnemy;
import walnoot.ld26.entities.enemies.SplitEnemy;

public class WaveManager {
    public static WaveManager instance;
    private static String[] NUMBERS;
    private int currentWave = 0;
    public int enemiesRemaining;
    private final Label waveText;
    private final GameWorld world;
    private int startTimer = 540;

    static {
        NUMBERS = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty", "twenty-one", "twenty-two", "twenty-three", "twenty-four", "twenty-six", "twenty-seven", "twenty-eight", "twenty-nine", "thirty"};
    }

    public WaveManager(Label waveText, GameWorld world) {
        this.world = world;
        this.waveText = waveText;
        instance = this;
    }

    public void update() {
        if (this.currentWave == 0) {
            --this.startTimer;
            if (this.startTimer == 0) {
                ++this.currentWave;
                this.initWave();
            }
        } else if (this.enemiesRemaining == 0) {
            ++this.currentWave;
            this.initWave();
        }
    }

    private void initWave() {
        this.world.player.heal(this.world.player.getMaxHealth() / 3.0f);
        SoundManager.instance.newWave.play();
        if (this.currentWave - 1 < NUMBERS.length) {
            this.waveText.setText("wave " + NUMBERS[this.currentWave - 1]);
        } else {
            this.waveText.setText("wave potato");
        }
        this.enemiesRemaining = 3 + this.currentWave;
        float angle = MathUtils.random(0.0f, (float)Math.PI * 2);
        Vector2 spawnPoint = new Vector2(MathUtils.cos(angle), MathUtils.sin(angle)).mul(20.0f).add(this.world.player.pos);
        int i = 0;
        while (i < this.enemiesRemaining) {
            float randAngle = MathUtils.random(0.0f, (float)Math.PI * 2);
            Vector2 pos = Vector2.tmp.set(MathUtils.cos(randAngle), MathUtils.sin(randAngle)).mul(5.0f).add(spawnPoint);
            if (i < this.enemiesRemaining / 3) {
                this.world.addEntity(new ChargeEnemy(pos.x, pos.y, this.world.player));
            } else if (i == this.enemiesRemaining / 3 && this.currentWave >= 3 && this.currentWave % 2 == 1) {
                this.world.addEntity(new SplitEnemy(pos.x, pos.y, this.world.player));
            } else {
                this.world.addEntity(new BasicEnemy(pos.x, pos.y, this.world.player));
            }
            ++i;
        }
    }

    public void onEnemyDeath() {
        --this.enemiesRemaining;
    }
}

