/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.Shape;
import walnoot.ld26.GameWorld;

public class Util {
    public static final CircleShape CIRCLE_SHAPE = Util.getCircleShape(1.0f);
    public static final Mesh SQUARE_MESH = Util.getSquareMesh();

    public static void hsvToRgb(float hue, float saturation, float value, Color color) {
        float b;
        float g;
        float r;
        int h = (int)(hue * 6.0f);
        float f = hue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        if (h == 0) {
            r = value;
            g = t;
            b = p;
        } else if (h == 1) {
            r = q;
            g = value;
            b = p;
        } else if (h == 2) {
            r = p;
            g = value;
            b = t;
        } else if (h == 3) {
            r = p;
            g = q;
            b = value;
        } else if (h == 4) {
            r = t;
            g = p;
            b = value;
        } else if (h == 5) {
            r = value;
            g = p;
            b = q;
        } else {
            throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
        }
        color.set(r, g, b, 1.0f);
    }

    private static Mesh getSquareMesh() {
        Mesh mesh = new Mesh(true, 4, 0, new VertexAttribute(0, 2, "a_position"));
        mesh.setVertices(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f});
        return mesh;
    }

    public static Body getCircleBody(Vector2 position) {
        return Util.getCircleBody(position, CIRCLE_SHAPE);
    }

    public static Body getCircleBody(Vector2 position, CircleShape shape) {
        BodyDef bodyDef = Util.getBodyDef();
        bodyDef.position.set(position);
        Body body = GameWorld.instance.physicsWorld.createBody(bodyDef);
        body.createFixture(Util.getFixtureDef(shape));
        return body;
    }

    private static FixtureDef getFixtureDef(Shape shape) {
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = shape;
        fixtureDef.density = 0.5f;
        fixtureDef.friction = 0.4f;
        fixtureDef.restitution = 1.0f;
        return fixtureDef;
    }

    public static CircleShape getCircleShape(float radius) {
        CircleShape circle = new CircleShape();
        circle.setRadius(radius);
        return circle;
    }

    private static BodyDef getBodyDef() {
        BodyDef bodyDef = new BodyDef();
        bodyDef.linearDamping = 0.5f;
        bodyDef.angularDamping = 0.9f;
        bodyDef.type = BodyDef.BodyType.DynamicBody;
        bodyDef.position.set(0.0f, 0.0f);
        return bodyDef;
    }

    public static boolean keyDown(int ... keys) {
        int i = 0;
        while (i < keys.length) {
            if (Gdx.input.isKeyPressed(keys[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

