/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.Table;
import walnoot.ld26.GameWorld;
import walnoot.ld26.WaveManager;
import walnoot.ld26.entities.PlayerEntity;
import walnoot.ld26.entities.WreckBallEntity;
import walnoot.ld26.particles.ParticleHandler;

public class LDGame
implements ApplicationListener {
    public static final float UPDATES_PER_SECOND = 60.0f;
    public static final float SECONDS_PER_UPDATE = 0.016666668f;
    public static final int LOGO_SHOW_TIME = 540;
    public static final int LOGO_FADE_TIME = 60;
    public static final int GAME_OVER_TIME = 240;
    private static final float MIN_ZOOM = 16.0f;
    private OrthographicCamera camera;
    private GameWorld world;
    private float updateTimer;
    private Stage stage;
    private int logoTimer;
    private int gameOverTimer;
    private Image logo;
    private Label waveLabel;
    private Label tutorialLabel;
    private Table tutorialTable;
    private Label gameOverLabel;
    private WaveManager waveManager;

    @Override
    public void create() {
        this.camera = new OrthographicCamera();
        this.updateCamera(16.0f);
        this.loadStage();
        this.loadWorld();
    }

    private void loadWorld() {
        this.world = new GameWorld();
        WreckBallEntity ball = new WreckBallEntity(-3.0f, 0.0f);
        this.world.addEntity(ball);
        PlayerEntity player = new PlayerEntity(0.0f, 0.0f, ball);
        this.world.addEntity(player);
        Gdx.input.setInputProcessor(player);
        this.waveManager = new WaveManager(this.waveLabel, this.world);
    }

    private void loadStage() {
        this.stage = new Stage(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
        Table logoTable = new Table();
        logoTable.top().setFillParent(true);
        this.logo = new Image(new Texture("logo.png"));
        logoTable.add(this.logo);
        this.stage.addActor(logoTable);
        Label.LabelStyle labelStyle = new Label.LabelStyle(new BitmapFont(Gdx.files.internal("font.fnt"), false), Color.WHITE);
        Table waveTable = new Table();
        waveTable.left().bottom().pad(32).setFillParent(true);
        this.waveLabel = new Label((CharSequence)"", labelStyle);
        waveTable.add(this.waveLabel);
        this.stage.addActor(waveTable);
        this.tutorialTable = new Table();
        this.tutorialTable.setFillParent(true);
        this.tutorialLabel = new Label((CharSequence)"move with directional keys", labelStyle);
        this.tutorialTable.add(this.tutorialLabel);
        this.stage.addActor(this.tutorialTable);
        Table gameOverTable = new Table();
        gameOverTable.setFillParent(true);
        this.gameOverLabel = new Label((CharSequence)"game over", labelStyle);
        this.gameOverLabel.color.a = 0.0f;
        gameOverTable.add(this.gameOverLabel);
        this.stage.addActor(gameOverTable);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    @Override
    public void render() {
        this.updateTimer += Gdx.graphics.getDeltaTime();
        while (this.updateTimer > 0.016666668f) {
            this.updateTimer -= 0.016666668f;
            this.update();
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16640);
        this.camera.update();
        this.camera.apply(Gdx.gl10);
        Gdx.gl10.glEnable(2929);
        this.world.render(this.camera);
        Gdx.gl10.glDisable(2929);
        ParticleHandler.instance.render();
        this.stage.draw();
    }

    private void update() {
        float zoom = Math.max(Math.abs(this.world.player.pos.x - this.world.ball.pos.x), Math.abs(this.world.player.pos.y - this.world.ball.pos.y));
        this.updateCamPos();
        this.updateCamera(Math.max(zoom + 2.0f, 16.0f));
        this.waveManager.update();
        this.world.update();
        this.handleFade();
        ParticleHandler.instance.update();
    }

    private void handleFade() {
        ++this.logoTimer;
        if (this.world.player.removed) {
            if (this.gameOverTimer == 0) {
                this.gameOverLabel.setText("game over\n(killed " + this.world.player.murderCount + " enemies)");
            }
            this.gameOverLabel.color.a = Math.min(1.0f, (float)this.gameOverTimer / 60.0f);
            this.waveLabel.color.a = Math.max(0.0f, 1.0f - (float)this.gameOverTimer / 60.0f);
            if (this.gameOverTimer > 60) {
                this.waveLabel.setText("");
            }
            ++this.gameOverTimer;
            if (this.gameOverTimer > 240) {
                this.loadWorld();
                this.gameOverLabel.color.a = 0.0f;
                this.waveLabel.color.a = 1.0f;
                this.gameOverTimer = 0;
            }
        }
        if (this.logoTimer > 180) {
            this.tutorialLabel.setText("space attracts the ball");
        }
        if (this.logoTimer > 360) {
            this.tutorialLabel.setText("don't get hit");
        }
        if (this.logoTimer > 540) {
            this.logo.color.a = 1.0f - (float)(this.logoTimer - 540) / 60.0f;
            this.stage.removeActor(this.tutorialTable);
        }
        if (this.logoTimer > 600) {
            this.stage.removeActor(this.logo);
        }
    }

    private void updateCamPos() {
        float targetX = (this.world.ball.pos.x + this.world.player.pos.x) * 0.5f;
        float targetY = (this.world.ball.pos.y + this.world.player.pos.y) * 0.5f;
        this.camera.position.x += (targetX - this.camera.position.x) * 0.05f;
        this.camera.position.y += (targetY - this.camera.position.y) * 0.05f;
    }

    private void updateCamera(float zoom) {
        float w = Gdx.graphics.getWidth();
        float h = Gdx.graphics.getHeight();
        this.camera.viewportHeight = zoom;
        this.camera.viewportWidth = zoom * w / h;
    }

    @Override
    public void resize(int width, int height) {
        this.stage.setViewport(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }
}

