/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld26;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import walnoot.ld26.entities.Entity;
import walnoot.ld26.entities.LivingEntity;
import walnoot.ld26.entities.PhysicsEntity;
import walnoot.ld26.entities.PlayerEntity;
import walnoot.ld26.entities.WreckBallEntity;
import walnoot.ld26.entities.enemies.EnemyEntity;

public class GameWorld
implements ContactListener {
    public static GameWorld instance;
    private Array<Entity> entities = new Array(false, 32);
    private Mesh lineMesh;
    public WreckBallEntity ball;
    public PlayerEntity player;
    public World physicsWorld;

    public GameWorld() {
        instance = this;
        this.lineMesh = new Mesh(true, 3, 0, new VertexAttribute(0, 2, "a_position"));
        this.lineMesh.setVertices(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        this.setupBox2D();
    }

    private void setupBox2D() {
        this.physicsWorld = new World(new Vector2(), true);
        this.physicsWorld.setContactListener(this);
    }

    public void render(OrthographicCamera camera) {
        this.renderGrid(camera);
        for (Entity e : this.entities) {
            e.render();
        }
    }

    public void update() {
        this.physicsWorld.step(0.016666668f, 6, 2);
        int i = 0;
        while (i < this.entities.size) {
            Entity e = this.entities.get(i);
            if (!e.removed) {
                e.update();
            } else {
                e.onRemove();
                this.entities.removeIndex(i);
                --i;
                if (e instanceof PhysicsEntity) {
                    this.physicsWorld.destroyBody(((PhysicsEntity)e).getBody());
                }
            }
            ++i;
        }
    }

    private void renderGrid(OrthographicCamera camera) {
        Gdx.gl10.glLineWidth(2.0f);
        Gdx.gl10.glColor4f(0.1f, 0.1f, 0.1f, 1.0f);
        int startX = (int)(camera.position.x - camera.viewportWidth * 0.5f);
        int startY = (int)(camera.position.y - camera.viewportHeight * 0.5f);
        int x = -1;
        while (x < (int)camera.viewportWidth + 1) {
            int y = -1;
            while (y < (int)camera.viewportHeight + 1) {
                Gdx.gl10.glPushMatrix();
                Gdx.gl10.glTranslatef(startX + x, startY + y, -1.0f);
                this.lineMesh.render(3);
                Gdx.gl10.glPopMatrix();
                ++y;
            }
            ++x;
        }
    }

    public void addEntity(Entity e) {
        this.entities.add(e);
        if (e instanceof WreckBallEntity) {
            this.ball = (WreckBallEntity)e;
        }
        if (e instanceof PlayerEntity) {
            this.player = (PlayerEntity)e;
        }
    }

    @Override
    public void beginContact(Contact contact) {
    }

    @Override
    public void endContact(Contact contact) {
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
        Object a = contact.getFixtureA().getBody().getUserData();
        Object b = contact.getFixtureB().getBody().getUserData();
        if (!(a instanceof EnemyEntity) || !(b instanceof EnemyEntity)) {
            this.checkHurt(a, impulse.getNormalImpulses()[0]);
            this.checkHurt(b, impulse.getNormalImpulses()[0]);
        }
    }

    private void checkHurt(Object userData, float damage) {
        if (userData instanceof LivingEntity) {
            ((LivingEntity)userData).damage(damage);
        }
    }
}

