/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Cullable;
import com.badlogic.gdx.scenes.scene2d.ui.SelectionListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class List
extends Widget
implements Cullable {
    private ListStyle style;
    private String[] items;
    private int selected;
    private SelectionListener listener;
    private Rectangle cullingArea;
    private float prefWidth;
    private float prefHeight;
    private float itemHeight;
    private float textOffsetX;
    private float textOffsetY;

    public List(Skin skin) {
        this((Object[])new String[0], skin);
    }

    public List(Object[] items, Skin skin) {
        this(items, skin.getStyle(ListStyle.class), null);
    }

    public List(Object[] items, ListStyle style) {
        this(items, style, null);
    }

    public List(Object[] items, ListStyle style, String name) {
        super(name);
        this.setStyle(style);
        this.setItems(items);
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public void setStyle(ListStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        if (this.items != null) {
            this.setItems(this.items);
        } else {
            this.invalidateHierarchy();
        }
    }

    public ListStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        BitmapFont font = this.style.font;
        NinePatch selectedPatch = this.style.selectedPatch;
        Color fontColorSelected = this.style.fontColorSelected;
        Color fontColorUnselected = this.style.fontColorUnselected;
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        font.setColor(fontColorUnselected.r, fontColorUnselected.g, fontColorUnselected.b, fontColorUnselected.a * parentAlpha);
        float itemY = this.height;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.cullingArea == null || itemY - this.itemHeight <= this.cullingArea.y + this.cullingArea.height && itemY >= this.cullingArea.y) {
                if (this.selected == i) {
                    selectedPatch.draw(batch, this.x, this.y + itemY - this.itemHeight, Math.max(this.prefWidth, this.width), this.itemHeight);
                    font.setColor(fontColorSelected.r, fontColorSelected.g, fontColorSelected.b, fontColorSelected.a * parentAlpha);
                }
                font.draw(batch, this.items[i], this.x + this.textOffsetX, this.y + itemY - this.textOffsetY);
                if (this.selected == i) {
                    font.setColor(fontColorUnselected.r, fontColorUnselected.g, fontColorUnselected.b, fontColorUnselected.a * parentAlpha);
                }
            } else if (itemY < this.cullingArea.y) break;
            itemY -= this.itemHeight;
        }
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        this.selected = (int)((this.height - y) / this.itemHeight);
        this.selected = Math.max(0, this.selected);
        this.selected = Math.min(this.items.length - 1, this.selected);
        if (this.listener != null && this.items.length > 0) {
            this.listener.selected(this, this.selected, this.items[this.selected]);
        }
        return true;
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.items.length) {
            throw new GdxRuntimeException("index must be >= 0 and < " + this.items.length + ": " + index);
        }
        this.selected = index;
    }

    public String getSelection() {
        if (this.items.length == 0) {
            return null;
        }
        return this.items[this.selected];
    }

    public int setSelection(String item) {
        this.selected = -1;
        int n = this.items.length;
        for (int i = 0; i < n; ++i) {
            if (!this.items[i].equals(item)) continue;
            this.selected = i;
            break;
        }
        return this.selected;
    }

    public void setItems(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("items cannot be null.");
        }
        if (!(objects instanceof String[])) {
            String[] strings = new String[objects.length];
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                strings[i] = String.valueOf(objects[i]);
            }
            this.items = strings;
        } else {
            this.items = (String[])objects;
        }
        this.selected = 0;
        BitmapFont font = this.style.font;
        NinePatch selectedPatch = this.style.selectedPatch;
        this.itemHeight = font.getCapHeight() - font.getDescent() * 2.0f;
        this.itemHeight += selectedPatch.getTopHeight() + selectedPatch.getBottomHeight();
        this.prefWidth += selectedPatch.getLeftWidth() + selectedPatch.getRightWidth();
        this.textOffsetX = selectedPatch.getLeftWidth();
        this.textOffsetY = selectedPatch.getTopHeight() - font.getDescent();
        this.prefWidth = 0.0f;
        for (int i = 0; i < this.items.length; ++i) {
            BitmapFont.TextBounds bounds = font.getBounds(this.items[i]);
            this.prefWidth = Math.max(bounds.width, this.prefWidth);
        }
        this.prefHeight = (float)this.items.length * this.itemHeight;
        this.invalidateHierarchy();
    }

    public String[] getItems() {
        return this.items;
    }

    @Override
    public float getPrefWidth() {
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        return this.prefHeight;
    }

    public void setSelectionListener(SelectionListener listener) {
        this.listener = listener;
    }

    @Override
    public void setCullingArea(Rectangle cullingArea) {
        this.cullingArea = cullingArea;
    }

    public static class ListStyle {
        public BitmapFont font;
        public Color fontColorSelected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color fontColorUnselected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public NinePatch selectedPatch;

        public ListStyle() {
        }

        public ListStyle(BitmapFont font, Color fontColorSelected, Color fontColorUnselected, NinePatch selectedPatch) {
            this.font = font;
            this.fontColorSelected.set(fontColorSelected);
            this.fontColorUnselected.set(fontColorUnselected);
            this.selectedPatch = selectedPatch;
        }

        public ListStyle(ListStyle style) {
            this.font = style.font;
            this.fontColorSelected.set(style.fontColorSelected);
            this.fontColorUnselected.set(style.fontColorUnselected);
            this.selectedPatch = style.selectedPatch;
        }
    }
}

