/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.interpolators;

import com.badlogic.gdx.scenes.scene2d.Interpolator;
import com.badlogic.gdx.utils.Pool;

public class OvershootInterpolator
implements Interpolator {
    private static final float DEFAULT_FACTOR = 1.0f;
    private static final Pool<OvershootInterpolator> pool = new Pool<OvershootInterpolator>(4, 100){

        @Override
        protected OvershootInterpolator newObject() {
            return new OvershootInterpolator();
        }
    };
    private float factor;
    private double doubledFactor;

    OvershootInterpolator() {
    }

    public static OvershootInterpolator $(float factor) {
        OvershootInterpolator inter = pool.obtain();
        inter.factor = factor;
        inter.doubledFactor = factor * 2.0f;
        return inter;
    }

    public static OvershootInterpolator $() {
        return OvershootInterpolator.$(1.0f);
    }

    @Override
    public void finished() {
        pool.free(this);
    }

    @Override
    public float getInterpolation(float t) {
        return (t -= 1.0f) * t * ((this.factor + 1.0f) * t + this.factor) + 1.0f;
    }

    @Override
    public Interpolator copy() {
        return OvershootInterpolator.$(this.factor);
    }
}

