/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class Repeat
extends TemporalAction {
    static final ActionResetingPool<Repeat> pool = new ActionResetingPool<Repeat>(4, 100){

        @Override
        protected Repeat newObject() {
            return new Repeat();
        }
    };
    protected int times;
    protected int finishedTimes;

    public static Repeat $(Action action, int times) {
        Repeat repeat = (Repeat)pool.obtain();
        repeat.action = action;
        repeat.times = times;
        return repeat;
    }

    @Override
    public void reset() {
        super.reset();
        this.finishedTimes = 0;
        this.listener = null;
    }

    @Override
    public void setTarget(Actor actor) {
        this.action.setTarget(actor);
        this.target = actor;
    }

    @Override
    public void act(float delta) {
        this.action.act(delta);
        if (this.action.isDone()) {
            ++this.finishedTimes;
            if (this.finishedTimes < this.times) {
                Action oldAction = this.action;
                this.action = this.action.copy();
                oldAction.finish();
                this.action.setTarget(this.target);
            } else {
                this.callActionCompletedListener();
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.finishedTimes >= this.times;
    }

    @Override
    public void finish() {
        pool.free(this);
        this.action.finish();
        super.finish();
    }

    @Override
    public Action copy() {
        return Repeat.$(this.action.copy(), this.times);
    }

    @Override
    public Actor getTarget() {
        return this.target;
    }
}

