/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Interpolator;

public abstract class AnimationAction
extends Action {
    protected float duration;
    protected float invDuration;
    protected float taken;
    protected Actor target;
    protected boolean done;
    protected Interpolator interpolator;

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void finish() {
        super.finish();
        if (this.interpolator != null) {
            this.interpolator.finished();
        }
    }

    public AnimationAction setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    protected float createInterpolatedAlpha(float delta) {
        this.taken += delta;
        if (this.taken >= this.duration) {
            this.taken = this.duration;
            this.done = true;
            return this.taken;
        }
        if (this.interpolator == null) {
            return this.taken * this.invDuration;
        }
        return this.interpolator.getInterpolation(this.taken * this.invDuration);
    }

    @Override
    public Actor getTarget() {
        return this.target;
    }

    @Override
    public void reset() {
        super.reset();
        this.interpolator = null;
    }
}

