/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class BitmapFont
implements Disposable {
    private static final int LOG2_PAGE_SIZE = 9;
    private static final int PAGE_SIZE = 512;
    private static final int PAGES = 128;
    public static final char[] xChars = new char[]{'x', 'e', 'a', 'o', 'n', 's', 'r', 'c', 'u', 'm', 'v', 'w', 'z'};
    public static final char[] capChars = new char[]{'M', 'N', 'B', 'D', 'C', 'E', 'F', 'K', 'A', 'G', 'H', 'I', 'J', 'L', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    TextureRegion region;
    private final TextBounds textBounds = new TextBounds();
    private float color = Color.WHITE.toFloatBits();
    private Color tempColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private boolean flipped;
    private boolean integer = true;
    final BitmapFontData data;
    private boolean ownsTexture;

    public BitmapFont() {
        this(Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.fnt"), Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.png"), false, true);
    }

    public BitmapFont(boolean flip) {
        this(Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.fnt"), Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.png"), flip, true);
    }

    public BitmapFont(FileHandle fontFile, TextureRegion region, boolean flip) {
        this(new BitmapFontData(fontFile, flip), region, true);
    }

    public BitmapFont(FileHandle fontFile, boolean flip) {
        this(new BitmapFontData(fontFile, flip), null, true);
    }

    public BitmapFont(FileHandle fontFile, FileHandle imageFile, boolean flip) {
        this(fontFile, imageFile, flip, true);
    }

    public BitmapFont(FileHandle fontFile, FileHandle imageFile, boolean flip, boolean integer) {
        this(new BitmapFontData(fontFile, flip), new TextureRegion(new Texture(imageFile, false)), integer);
        this.ownsTexture = true;
    }

    public BitmapFont(BitmapFontData data, TextureRegion region, boolean integer) {
        this.region = region == null ? new TextureRegion(new Texture(Gdx.files.internal(data.imagePath), false)) : region;
        this.flipped = data.flipped;
        this.integer = integer;
        this.data = data;
        this.load(data);
        this.ownsTexture = region == null;
    }

    private void load(BitmapFontData data) {
        float invTexWidth = 1.0f / (float)this.region.getTexture().getWidth();
        float invTexHeight = 1.0f / (float)this.region.getTexture().getHeight();
        float u = this.region.u;
        float v = this.region.v;
        for (Glyph[] page : data.glyphs) {
            if (page == null) continue;
            for (Glyph glyph : page) {
                if (glyph == null) continue;
                glyph.u = u + (float)glyph.srcX * invTexWidth;
                glyph.u2 = u + (float)(glyph.srcX + glyph.width) * invTexWidth;
                if (data.flipped) {
                    glyph.v = v + (float)glyph.srcY * invTexHeight;
                    glyph.v2 = v + (float)(glyph.srcY + glyph.height) * invTexHeight;
                    continue;
                }
                glyph.v2 = v + (float)glyph.srcY * invTexHeight;
                glyph.v = v + (float)(glyph.srcY + glyph.height) * invTexHeight;
            }
        }
    }

    public TextBounds draw(SpriteBatch spriteBatch, CharSequence str, float x, float y) {
        return this.draw(spriteBatch, str, x, y, 0, str.length());
    }

    public TextBounds draw(SpriteBatch spriteBatch, CharSequence str, float x, float y, int start, int end) {
        float batchColor = spriteBatch.color;
        spriteBatch.setColor(this.color);
        Texture texture = this.region.getTexture();
        y += this.data.ascent;
        float startX = x;
        Glyph lastGlyph = null;
        if (this.data.scaleX == 1.0f && this.data.scaleY == 1.0f) {
            if (this.integer) {
                y = (int)y;
                x = (int)x;
            }
            while (start < end) {
                if ((lastGlyph = this.data.getGlyph(str.charAt(start++))) == null) continue;
                spriteBatch.draw(texture, x + (float)lastGlyph.xoffset, y + (float)lastGlyph.yoffset, lastGlyph.width, lastGlyph.height, lastGlyph.u, lastGlyph.v, lastGlyph.u2, lastGlyph.v2);
                x += (float)lastGlyph.xadvance;
                break;
            }
            while (start < end) {
                char ch;
                Glyph g;
                if ((g = this.data.getGlyph(ch = str.charAt(start++))) == null) continue;
                x += (float)lastGlyph.getKerning(ch);
                if (this.integer) {
                    x = (int)x;
                }
                lastGlyph = g;
                spriteBatch.draw(texture, x + (float)lastGlyph.xoffset, y + (float)lastGlyph.yoffset, lastGlyph.width, lastGlyph.height, lastGlyph.u, lastGlyph.v, lastGlyph.u2, lastGlyph.v2);
                x += (float)g.xadvance;
            }
        } else {
            float scaleX = this.data.scaleX;
            float scaleY = this.data.scaleY;
            while (start < end) {
                if ((lastGlyph = this.data.getGlyph(str.charAt(start++))) == null) continue;
                if (!this.integer) {
                    spriteBatch.draw(texture, x + (float)lastGlyph.xoffset * scaleX, y + (float)lastGlyph.yoffset * scaleY, (float)lastGlyph.width * scaleX, (float)lastGlyph.height * scaleY, lastGlyph.u, lastGlyph.v, lastGlyph.u2, lastGlyph.v2);
                } else {
                    spriteBatch.draw(texture, (int)(x + (float)lastGlyph.xoffset * scaleX), (int)(y + (float)lastGlyph.yoffset * scaleY), (int)((float)lastGlyph.width * scaleX), (int)((float)lastGlyph.height * scaleY), lastGlyph.u, lastGlyph.v, lastGlyph.u2, lastGlyph.v2);
                }
                x += (float)lastGlyph.xadvance * scaleX;
                break;
            }
            while (start < end) {
                char ch;
                Glyph g;
                if ((g = this.data.getGlyph(ch = str.charAt(start++))) == null) continue;
                x += (float)lastGlyph.getKerning(ch) * scaleX;
                lastGlyph = g;
                if (!this.integer) {
                    spriteBatch.draw(texture, x + (float)lastGlyph.xoffset * scaleX, y + (float)lastGlyph.yoffset * scaleY, (float)lastGlyph.width * scaleX, (float)lastGlyph.height * scaleY, lastGlyph.u, lastGlyph.v, lastGlyph.u2, lastGlyph.v2);
                } else {
                    spriteBatch.draw(texture, (int)(x + (float)lastGlyph.xoffset * scaleX), (int)(y + (float)lastGlyph.yoffset * scaleY), (int)((float)lastGlyph.width * scaleX), (int)((float)lastGlyph.height * scaleY), lastGlyph.u, lastGlyph.v, lastGlyph.u2, lastGlyph.v2);
                }
                x += (float)g.xadvance * scaleX;
            }
        }
        spriteBatch.setColor(batchColor);
        this.textBounds.width = x - startX;
        this.textBounds.height = this.data.capHeight;
        return this.textBounds;
    }

    public TextBounds drawMultiLine(SpriteBatch spriteBatch, CharSequence str, float x, float y) {
        return this.drawMultiLine(spriteBatch, str, x, y, 0.0f, HAlignment.LEFT);
    }

    public TextBounds drawMultiLine(SpriteBatch spriteBatch, CharSequence str, float x, float y, float alignmentWidth, HAlignment alignment) {
        float batchColor = spriteBatch.color;
        float down = this.data.down;
        int start = 0;
        int numLines = 0;
        int length = str.length();
        float maxWidth = 0.0f;
        while (start < length) {
            float lineWidth;
            int lineEnd = BitmapFont.indexOf(str, '\n', start);
            float xOffset = 0.0f;
            if (alignment != HAlignment.LEFT) {
                lineWidth = this.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
                xOffset = alignmentWidth - lineWidth;
                if (alignment == HAlignment.CENTER) {
                    xOffset /= 2.0f;
                }
            }
            lineWidth = this.draw((SpriteBatch)spriteBatch, (CharSequence)str, (float)(x + xOffset), (float)y, (int)start, (int)lineEnd).width;
            maxWidth = Math.max(maxWidth, lineWidth);
            start = lineEnd + 1;
            y += down;
            ++numLines;
        }
        spriteBatch.setColor(batchColor);
        this.textBounds.width = maxWidth;
        this.textBounds.height = this.data.capHeight + (float)(numLines - 1) * this.data.lineHeight;
        return this.textBounds;
    }

    public TextBounds drawWrapped(SpriteBatch spriteBatch, CharSequence str, float x, float y, float wrapWidth) {
        return this.drawWrapped(spriteBatch, str, x, y, wrapWidth, HAlignment.LEFT);
    }

    public TextBounds drawWrapped(SpriteBatch spriteBatch, CharSequence str, float x, float y, float wrapWidth, HAlignment alignment) {
        if (wrapWidth <= 0.0f) {
            wrapWidth = 2.1474836E9f;
        }
        float batchColor = spriteBatch.color;
        float down = this.data.down;
        int start = 0;
        int numLines = 0;
        int length = str.length();
        float maxWidth = 0.0f;
        while (start < length) {
            int lineEnd;
            int newLine = BitmapFont.indexOf(str, '\n', start);
            while (start < newLine && BitmapFont.isWhitespace(str.charAt(start))) {
                ++start;
            }
            int nextStart = lineEnd + 1;
            if (lineEnd < newLine) {
                for (lineEnd = start + this.computeVisibleGlyphs(str, start, newLine, wrapWidth); lineEnd > start && !BitmapFont.isWhitespace(str.charAt(lineEnd)); --lineEnd) {
                }
                if (lineEnd == start) {
                    lineEnd = nextStart - 1;
                } else {
                    nextStart = lineEnd;
                    while (lineEnd > start && BitmapFont.isWhitespace(str.charAt(lineEnd - 1))) {
                        --lineEnd;
                    }
                }
            } else {
                nextStart = lineEnd + 1;
            }
            if (lineEnd > start) {
                float lineWidth;
                float xOffset = 0.0f;
                if (alignment != HAlignment.LEFT) {
                    lineWidth = this.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
                    xOffset = wrapWidth - lineWidth;
                    if (alignment == HAlignment.CENTER) {
                        xOffset /= 2.0f;
                    }
                }
                lineWidth = this.draw((SpriteBatch)spriteBatch, (CharSequence)str, (float)(x + xOffset), (float)y, (int)start, (int)lineEnd).width;
                maxWidth = Math.max(maxWidth, lineWidth);
            }
            start = nextStart;
            y += down;
            ++numLines;
        }
        spriteBatch.setColor(batchColor);
        this.textBounds.width = maxWidth;
        this.textBounds.height = this.data.capHeight + (float)(numLines - 1) * this.data.lineHeight;
        return this.textBounds;
    }

    public TextBounds getBounds(CharSequence str) {
        return this.getBounds(str, 0, str.length());
    }

    public TextBounds getBounds(CharSequence str, TextBounds textBounds) {
        return this.getBounds(str, 0, str.length());
    }

    public TextBounds getBounds(CharSequence str, int start, int end) {
        return this.getBounds(str, start, end, this.textBounds);
    }

    public TextBounds getBounds(CharSequence str, int start, int end, TextBounds textBounds) {
        int width = 0;
        Glyph lastGlyph = null;
        while (start < end) {
            if ((lastGlyph = this.data.getGlyph(str.charAt(start++))) == null) continue;
            width = lastGlyph.xadvance;
            break;
        }
        while (start < end) {
            char ch;
            Glyph g;
            if ((g = this.data.getGlyph(ch = str.charAt(start++))) == null) continue;
            width += lastGlyph.getKerning(ch);
            lastGlyph = g;
            width += g.xadvance;
        }
        textBounds.width = (float)width * this.data.scaleX;
        textBounds.height = this.data.capHeight;
        return textBounds;
    }

    public TextBounds getMultiLineBounds(CharSequence str) {
        return this.getMultiLineBounds(str, this.textBounds);
    }

    public TextBounds getMultiLineBounds(CharSequence str, TextBounds textBounds) {
        int start = 0;
        float maxWidth = 0.0f;
        int numLines = 0;
        int length = str.length();
        while (start < length) {
            int lineEnd = BitmapFont.indexOf(str, '\n', start);
            float lineWidth = this.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
            maxWidth = Math.max(maxWidth, lineWidth);
            start = lineEnd + 1;
            ++numLines;
        }
        textBounds.width = maxWidth;
        textBounds.height = this.data.capHeight + (float)(numLines - 1) * this.data.lineHeight;
        return textBounds;
    }

    public TextBounds getWrappedBounds(CharSequence str, float wrapWidth) {
        return this.getWrappedBounds(str, wrapWidth, this.textBounds);
    }

    public TextBounds getWrappedBounds(CharSequence str, float wrapWidth, TextBounds textBounds) {
        if (wrapWidth <= 0.0f) {
            wrapWidth = 2.1474836E9f;
        }
        float down = this.data.down;
        int start = 0;
        int numLines = 0;
        int length = str.length();
        float maxWidth = 0.0f;
        while (start < length) {
            int lineEnd;
            int newLine = BitmapFont.indexOf(str, '\n', start);
            while (start < newLine && BitmapFont.isWhitespace(str.charAt(start))) {
                ++start;
            }
            int nextStart = lineEnd + 1;
            if (lineEnd < newLine) {
                for (lineEnd = start + this.computeVisibleGlyphs(str, start, newLine, wrapWidth); lineEnd > start && !BitmapFont.isWhitespace(str.charAt(lineEnd)); --lineEnd) {
                }
                if (lineEnd == start) {
                    lineEnd = nextStart - 1;
                } else {
                    nextStart = lineEnd;
                    while (lineEnd > start && BitmapFont.isWhitespace(str.charAt(lineEnd - 1))) {
                        --lineEnd;
                    }
                }
            }
            if (lineEnd > start) {
                float lineWidth = this.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
                maxWidth = Math.max(maxWidth, lineWidth);
            }
            start = nextStart;
            ++numLines;
        }
        textBounds.width = maxWidth;
        textBounds.height = this.data.capHeight + (float)(numLines - 1) * this.data.lineHeight;
        return textBounds;
    }

    public void computeGlyphAdvancesAndPositions(CharSequence str, FloatArray glyphAdvances, FloatArray glyphPositions) {
        int index;
        glyphAdvances.clear();
        glyphPositions.clear();
        int end = str.length();
        int width = 0;
        Glyph lastGlyph = null;
        if (this.data.scaleX == 1.0f) {
            for (index = 0; index < end; ++index) {
                char ch = str.charAt(index);
                Glyph g = this.data.getGlyph(ch);
                if (g == null) continue;
                if (lastGlyph != null) {
                    width += lastGlyph.getKerning(ch);
                }
                lastGlyph = g;
                glyphAdvances.add(g.xadvance);
                glyphPositions.add(width);
                width += g.xadvance;
            }
            glyphAdvances.add(0.0f);
            glyphPositions.add(width);
        } else {
            float scaleX = this.data.scaleX;
            while (index < end) {
                char ch = str.charAt(index);
                Glyph g = this.data.getGlyph(ch);
                if (g != null) {
                    if (lastGlyph != null) {
                        width = (int)((float)width + (float)lastGlyph.getKerning(ch) * scaleX);
                    }
                    lastGlyph = g;
                    glyphAdvances.add((float)g.xadvance * scaleX);
                    glyphPositions.add(width);
                    width += g.xadvance;
                }
                ++index;
            }
            glyphAdvances.add(0.0f);
            glyphPositions.add(width);
        }
    }

    public int computeVisibleGlyphs(CharSequence str, int start, int end, float availableWidth) {
        int index;
        float width = 0.0f;
        Glyph lastGlyph = null;
        if (this.data.scaleX == 1.0f) {
            for (index = start; index < end; ++index) {
                char ch = str.charAt(index);
                Glyph g = this.data.getGlyph(ch);
                if (g == null) continue;
                if (lastGlyph != null) {
                    width += (float)lastGlyph.getKerning(ch);
                }
                if (!(width + (float)g.xadvance - availableWidth > 0.001f)) {
                    width += (float)g.xadvance;
                    lastGlyph = g;
                    continue;
                }
                break;
            }
        } else {
            float scaleX = this.data.scaleX;
            while (index < end) {
                char ch = str.charAt(index);
                Glyph g = this.data.getGlyph(ch);
                if (g != null) {
                    if (lastGlyph != null) {
                        width += (float)lastGlyph.getKerning(ch) * scaleX;
                    }
                    if (width + (float)g.xadvance * scaleX - availableWidth > 0.001f) break;
                    width += (float)g.xadvance * scaleX;
                    lastGlyph = g;
                }
                ++index;
            }
        }
        return index - start;
    }

    public void setColor(float color) {
        this.color = color;
    }

    public void setColor(Color tint) {
        this.color = tint.toFloatBits();
    }

    public void setColor(float r, float g, float b, float a) {
        int intBits = (int)(255.0f * a) << 24 | (int)(255.0f * b) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        this.color = NumberUtils.intToFloatColor(intBits);
    }

    public Color getColor() {
        int intBits = NumberUtils.floatToIntColor(this.color);
        Color color = this.tempColor;
        color.r = (float)(intBits & 0xFF) / 255.0f;
        color.g = (float)(intBits >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(intBits >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(intBits >>> 24 & 0xFF) / 255.0f;
        return color;
    }

    public void setScale(float scaleX, float scaleY) {
        this.data.lineHeight = this.data.lineHeight / this.data.scaleX * scaleX;
        this.data.spaceWidth = this.data.spaceWidth / this.data.scaleX * scaleX;
        this.data.xHeight = this.data.xHeight / this.data.scaleY * scaleY;
        this.data.capHeight = this.data.capHeight / this.data.scaleY * scaleY;
        this.data.ascent = this.data.ascent / this.data.scaleY * scaleY;
        this.data.descent = this.data.descent / this.data.scaleY * scaleY;
        this.data.down = this.data.down / this.data.scaleY * scaleY;
        this.data.scaleX = scaleX;
        this.data.scaleY = scaleY;
    }

    public void setScale(float scaleXY) {
        this.setScale(scaleXY, scaleXY);
    }

    public void scale(float amount) {
        this.setScale(this.data.scaleX + amount, this.data.scaleY + amount);
    }

    public float getScaleX() {
        return this.data.scaleX;
    }

    public float getScaleY() {
        return this.data.scaleY;
    }

    public TextureRegion getRegion() {
        return this.region;
    }

    public float getLineHeight() {
        return this.data.lineHeight;
    }

    public float getSpaceWidth() {
        return this.data.spaceWidth;
    }

    public float getXHeight() {
        return this.data.xHeight;
    }

    public float getCapHeight() {
        return this.data.capHeight;
    }

    public float getAscent() {
        return this.data.ascent;
    }

    public float getDescent() {
        return this.data.descent;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public void dispose() {
        if (this.ownsTexture) {
            this.region.getTexture().dispose();
        }
    }

    public void setFixedWidthGlyphs(CharSequence glyphs) {
        Glyph g;
        int index;
        int maxAdvance = 0;
        int end = glyphs.length();
        for (index = 0; index < end; ++index) {
            g = this.data.getGlyph(glyphs.charAt(index));
            if (g == null || g.xadvance <= maxAdvance) continue;
            maxAdvance = g.xadvance;
        }
        end = glyphs.length();
        for (index = 0; index < end; ++index) {
            g = this.data.getGlyph(glyphs.charAt(index));
            if (g == null) continue;
            g.xoffset += (maxAdvance - g.xadvance) / 2;
            g.xadvance = maxAdvance;
            g.kerning = null;
        }
    }

    public boolean containsCharacter(char character) {
        return this.data.getGlyph(character) != null;
    }

    public void setUseIntegerPositions(boolean use) {
        this.integer = use;
    }

    public boolean usesIntegerPositions() {
        return this.integer;
    }

    public BitmapFontData getData() {
        return this.data;
    }

    static int indexOf(CharSequence text, char ch, int start) {
        int n = text.length();
        while (start < n) {
            if (text.charAt(start) == ch) {
                return start;
            }
            ++start;
        }
        return n;
    }

    static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static enum HAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static class TextBounds {
        public float width;
        public float height;

        public TextBounds() {
        }

        public TextBounds(TextBounds bounds) {
            this.set(bounds);
        }

        public void set(TextBounds bounds) {
            this.width = bounds.width;
            this.height = bounds.height;
        }
    }

    public static class Glyph {
        public int srcX;
        public int srcY;
        public int width;
        public int height;
        public float u;
        public float v;
        public float u2;
        public float v2;
        public int xoffset;
        public int yoffset;
        public int xadvance;
        public byte[][] kerning;

        public int getKerning(char ch) {
            byte[] page;
            if (this.kerning != null && (page = this.kerning[ch >>> 9]) != null) {
                return page[ch & 0x1FF];
            }
            return 0;
        }

        public void setKerning(int ch, int value) {
            byte[] page;
            if (this.kerning == null) {
                this.kerning = new byte[128][];
            }
            if ((page = this.kerning[ch >>> 9]) == null) {
                page = new byte[512];
                this.kerning[ch >>> 9] = page;
            }
            page[ch & 0x1FF] = (byte)value;
        }
    }

    public static class BitmapFontData {
        public String imagePath;
        public FileHandle fontFile;
        public boolean flipped;
        public float lineHeight;
        public float capHeight = 1.0f;
        public float ascent;
        public float descent;
        public float down;
        public float scaleX = 1.0f;
        public float scaleY = 1.0f;
        public final Glyph[][] glyphs = new Glyph[128][];
        public float spaceWidth;
        public float xHeight = 1.0f;

        public BitmapFontData() {
        }

        public BitmapFontData(FileHandle fontFile, boolean flip) {
            this.fontFile = fontFile;
            this.flipped = flip;
            BufferedReader reader = new BufferedReader(new InputStreamReader(fontFile.read()), 512);
            try {
                reader.readLine();
                String line = reader.readLine();
                if (line == null) {
                    throw new GdxRuntimeException("Invalid font file: " + fontFile);
                }
                String[] common = line.split(" ", 4);
                if (common.length < 4) {
                    throw new GdxRuntimeException("Invalid font file: " + fontFile);
                }
                if (!common[1].startsWith("lineHeight=")) {
                    throw new GdxRuntimeException("Invalid font file: " + fontFile);
                }
                this.lineHeight = Integer.parseInt(common[1].substring(11));
                if (!common[2].startsWith("base=")) {
                    throw new GdxRuntimeException("Invalid font file: " + fontFile);
                }
                int baseLine = Integer.parseInt(common[2].substring(5));
                line = reader.readLine();
                if (line == null) {
                    throw new GdxRuntimeException("Invalid font file: " + fontFile);
                }
                String[] pageLine = line.split(" ", 4);
                if (!pageLine[2].startsWith("file=")) {
                    throw new GdxRuntimeException("Invalid font file: " + fontFile);
                }
                String imgFilename = null;
                imgFilename = pageLine[2].endsWith("\"") ? pageLine[2].substring(6, pageLine[2].length() - 1) : pageLine[2].substring(5, pageLine[2].length());
                this.imagePath = fontFile.parent().child(imgFilename).path().replaceAll("\\\\", "/");
                this.descent = 0.0f;
                while ((line = reader.readLine()) != null && !line.startsWith("kernings ")) {
                    if (!line.startsWith("char ")) continue;
                    Glyph glyph = new Glyph();
                    StringTokenizer tokens = new StringTokenizer(line, " =");
                    tokens.nextToken();
                    tokens.nextToken();
                    int ch = Integer.parseInt(tokens.nextToken());
                    if (ch > 65535) continue;
                    this.setGlyph(ch, glyph);
                    tokens.nextToken();
                    glyph.srcX = Integer.parseInt(tokens.nextToken());
                    tokens.nextToken();
                    glyph.srcY = Integer.parseInt(tokens.nextToken());
                    tokens.nextToken();
                    glyph.width = Integer.parseInt(tokens.nextToken());
                    tokens.nextToken();
                    glyph.height = Integer.parseInt(tokens.nextToken());
                    tokens.nextToken();
                    glyph.xoffset = Integer.parseInt(tokens.nextToken());
                    tokens.nextToken();
                    glyph.yoffset = flip ? Integer.parseInt(tokens.nextToken()) : -(glyph.height + Integer.parseInt(tokens.nextToken()));
                    tokens.nextToken();
                    glyph.xadvance = Integer.parseInt(tokens.nextToken());
                    if (glyph.width <= 0 || glyph.height <= 0) continue;
                    this.descent = Math.min((float)(baseLine + glyph.yoffset), this.descent);
                }
                while ((line = reader.readLine()) != null && line.startsWith("kerning ")) {
                    StringTokenizer tokens = new StringTokenizer(line, " =");
                    tokens.nextToken();
                    tokens.nextToken();
                    int first = Integer.parseInt(tokens.nextToken());
                    tokens.nextToken();
                    int second = Integer.parseInt(tokens.nextToken());
                    if (first < 0 || first > 65535 || second < 0 || second > 65535) continue;
                    Glyph glyph = this.getGlyph((char)first);
                    tokens.nextToken();
                    int amount = Integer.parseInt(tokens.nextToken());
                    glyph.setKerning(second, amount);
                }
                Glyph spaceGlyph = this.getGlyph(' ');
                if (spaceGlyph == null) {
                    spaceGlyph = new Glyph();
                    Glyph xadvanceGlyph = this.getGlyph('l');
                    if (xadvanceGlyph == null) {
                        xadvanceGlyph = this.getFirstGlyph();
                    }
                    spaceGlyph.xadvance = xadvanceGlyph.xadvance;
                    this.setGlyph(32, spaceGlyph);
                }
                this.spaceWidth = spaceGlyph != null ? (float)(spaceGlyph.xadvance + spaceGlyph.width) : 1.0f;
                Glyph xGlyph = null;
                for (int i = 0; i < xChars.length && (xGlyph = this.getGlyph(xChars[i])) == null; ++i) {
                }
                if (xGlyph == null) {
                    xGlyph = this.getFirstGlyph();
                }
                this.xHeight = xGlyph.height;
                Glyph capGlyph = null;
                for (int i = 0; i < capChars.length && (capGlyph = this.getGlyph(capChars[i])) == null; ++i) {
                }
                if (capGlyph == null) {
                    for (Glyph[] page : this.glyphs) {
                        if (page == null) continue;
                        for (Glyph glyph : page) {
                            if (glyph == null || glyph.height == 0 || glyph.width == 0) continue;
                            this.capHeight = Math.max(this.capHeight, (float)glyph.height);
                        }
                    }
                } else {
                    this.capHeight = capGlyph.height;
                }
                this.ascent = (float)baseLine - this.capHeight;
                this.down = -this.lineHeight;
                if (flip) {
                    this.ascent = -this.ascent;
                    this.down = -this.down;
                }
            }
            catch (Exception ex) {
                throw new GdxRuntimeException("Error loading font file: " + fontFile, ex);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }

        public void setGlyph(int ch, Glyph glyph) {
            Glyph[] page = this.glyphs[ch / 512];
            if (page == null) {
                page = new Glyph[512];
                this.glyphs[ch / 512] = page;
            }
            page[ch & 0x1FF] = glyph;
        }

        public Glyph getFirstGlyph() {
            for (Glyph[] page : this.glyphs) {
                if (page == null) continue;
                for (Glyph glyph : page) {
                    if (glyph == null || glyph.height == 0 || glyph.width == 0) continue;
                    return glyph;
                }
            }
            throw new GdxRuntimeException("No glyphs found!");
        }

        public Glyph getGlyph(char ch) {
            Glyph[] page = this.glyphs[ch / 512];
            if (page != null) {
                return page[ch & 0x1FF];
            }
            return null;
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public FileHandle getFontFile() {
            return this.fontFile;
        }
    }
}

