/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class OrthographicCamera
extends Camera {
    public float zoom = 1.0f;
    private final Vector3 tmp = new Vector3();

    public OrthographicCamera() {
        this.near = 0.0f;
    }

    public OrthographicCamera(float viewportWidth, float viewportHeight) {
        this.viewportWidth = viewportWidth;
        this.viewportHeight = viewportHeight;
        this.near = 0.0f;
        this.update();
    }

    public OrthographicCamera(float viewportWidth, float viewportHeight, float diamondAngle) {
        this.viewportWidth = viewportWidth;
        this.viewportHeight = viewportHeight;
        this.near = 0.0f;
        this.findDirectionForIsoView(diamondAngle, 1.0E-8f, 20);
        this.update();
    }

    public void findDirectionForIsoView(float targetAngle, float epsilon, int maxIterations) {
        float start = targetAngle - 5.0f;
        float end = targetAngle + 5.0f;
        float mid = targetAngle;
        int iterations = 0;
        float aMid = 0.0f;
        while (Math.abs(targetAngle - aMid) > epsilon && iterations++ < maxIterations) {
            aMid = this.calculateAngle(mid);
            if (targetAngle < aMid) {
                end = mid;
            } else {
                start = mid;
            }
            mid = start + (end - start) / 2.0f;
        }
        this.position.set(this.calculateDirection(mid));
        this.position.y = -this.position.y;
        this.lookAt(0.0f, 0.0f, 0.0f);
        this.normalizeUp();
    }

    private float calculateAngle(float a) {
        Vector3 camPos = this.calculateDirection(a);
        this.position.set(camPos.mul(30.0f));
        this.lookAt(0.0f, 0.0f, 0.0f);
        this.normalizeUp();
        this.update();
        Vector3 orig = new Vector3(0.0f, 0.0f, 0.0f);
        Vector3 vec = new Vector3(1.0f, 0.0f, 0.0f);
        this.project(orig);
        this.project(vec);
        Vector2 d = new Vector2(vec.x - orig.x, -(vec.y - orig.y));
        return d.angle();
    }

    private Vector3 calculateDirection(float angle) {
        Matrix4 transform = new Matrix4();
        Vector3 dir = new Vector3(-1.0f, 0.0f, 1.0f).nor();
        float rotAngle = (float)Math.toDegrees(Math.asin(Math.tan(Math.toRadians(angle))));
        transform.setToRotation(new Vector3(1.0f, 0.0f, 1.0f).nor(), angle);
        dir.mul(transform).nor();
        return dir;
    }

    @Override
    public void update() {
        this.projection.setToOrtho(this.zoom * -this.viewportWidth / 2.0f, this.zoom * this.viewportWidth / 2.0f, this.zoom * -this.viewportHeight / 2.0f, this.zoom * this.viewportHeight / 2.0f, Math.abs(this.near), Math.abs(this.far));
        this.view.setToLookAt(this.position, this.tmp.set(this.position).add(this.direction), this.up);
        this.combined.set(this.projection);
        Matrix4.mul(this.combined.val, this.view.val);
        this.invProjectionView.set(this.combined);
        Matrix4.inv(this.invProjectionView.val);
        this.frustum.update(this.invProjectionView);
    }

    @Override
    public void update(boolean updateFrustum) {
        this.projection.setToOrtho(this.zoom * -this.viewportWidth / 2.0f, this.zoom * this.viewportWidth / 2.0f, this.zoom * -this.viewportHeight / 2.0f, this.zoom * this.viewportHeight / 2.0f, Math.abs(this.near), Math.abs(this.far));
        this.view.setToLookAt(this.position, this.tmp.set(this.position).add(this.direction), this.up);
        this.combined.set(this.projection);
        Matrix4.mul(this.combined.val, this.view.val);
        if (updateFrustum) {
            this.invProjectionView.set(this.combined);
            Matrix4.inv(this.invProjectionView.val);
            this.frustum.update(this.invProjectionView);
        }
    }

    public void setToOrtho(boolean yDown) {
        this.setToOrtho(yDown, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setToOrtho(boolean yDown, float viewportWidth, float viewportHeight) {
        if (yDown) {
            this.up.set(0.0f, -1.0f, 0.0f);
            this.direction.set(0.0f, 0.0f, 1.0f);
        }
        this.position.set(viewportWidth / 2.0f, viewportHeight / 2.0f, 0.0f);
        this.viewportWidth = viewportWidth;
        this.viewportHeight = viewportHeight;
        this.update();
    }

    public void rotate(float angle) {
        this.rotate(this.direction, angle);
    }

    public void translate(float x, float y) {
        this.translate(x, y, 0.0f);
    }

    public void translate(Vector2 vec) {
        this.translate(vec.x, vec.y, 0.0f);
    }
}

