/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.graphics.g2d.tiled.TileAtlas;
import com.badlogic.gdx.graphics.g2d.tiled.TileMapRenderer;
import com.badlogic.gdx.graphics.g2d.tiled.TiledLoader;
import com.badlogic.gdx.graphics.g2d.tiled.TiledMap;
import com.badlogic.gdx.utils.Array;

public class TileMapRendererLoader
extends SynchronousAssetLoader<TileMapRenderer, TileMapParameter> {
    public TileMapRendererLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, TileMapParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Missing TileMapRendererParameter: " + fileName);
        }
        return null;
    }

    @Override
    public TileMapRenderer load(AssetManager assetManager, String fileName, TileMapParameter parameter) {
        TiledMap map = TiledLoader.createMap(this.resolve(fileName));
        TileAtlas atlas = new TileAtlas(map, this.resolve(parameter.imageDirectory));
        if (parameter.unitsPerTileX == 0.0f || parameter.unitsPerTileY == 0.0f) {
            return new TileMapRenderer(map, atlas, parameter.tilesPerBlockX, parameter.tilesPerBlockY);
        }
        return new TileMapRenderer(map, atlas, parameter.tilesPerBlockX, parameter.tilesPerBlockY, parameter.unitsPerTileX, parameter.unitsPerTileY);
    }

    public static class TileMapParameter
    extends AssetLoaderParameters<TileMapRenderer> {
        public final String imageDirectory;
        public final int tilesPerBlockX;
        public final int tilesPerBlockY;
        public final float unitsPerTileX;
        public final float unitsPerTileY;

        public TileMapParameter(String imageDirectory, int tilesPerBlockX, int tilesPerBlockY) {
            this.imageDirectory = imageDirectory;
            this.tilesPerBlockX = tilesPerBlockX;
            this.tilesPerBlockY = tilesPerBlockY;
            this.unitsPerTileX = 0.0f;
            this.unitsPerTileY = 0.0f;
        }

        public TileMapParameter(String imageDirectory, int tilesPerBlockX, int tilesPerBlockY, float unitsPerTileX, float unitsPerTileY) {
            this.imageDirectory = imageDirectory;
            this.tilesPerBlockX = tilesPerBlockX;
            this.tilesPerBlockY = tilesPerBlockY;
            this.unitsPerTileX = unitsPerTileX;
            this.unitsPerTileY = unitsPerTileY;
        }
    }
}

